using System;
using System.Runtime.Serialization;
using System.Security.Permissions;
using gov.va.med.vbecs.ExceptionManagement;

namespace gov.va.med.vbecs.BOL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Margaret Jablonski</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>9/3/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Broken Rule Exception</summary>

	#endregion

	[Serializable]
	public class BrokenRuleException : BaseApplicationException
	{
		private string _OSVersion = Environment.OSVersion.ToString();
		private string _stackTrace = Environment.StackTrace.ToString();
		private string _machineName = Environment.MachineName.ToString();
		private string _userName = Common.LogonUser.LogonUserName;

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>09/03/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3409"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>BrokenRuleException object</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="2991"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Empty constructor
		/// </summary>
		public BrokenRuleException() : base()
		{
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>09/03/2003</CreationDate>
		///<TestCases>		
		///
		///<Case type="0" testid ="3410"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>BrokenRuleException object and valid string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3411"> 
		///		<ExpectedInput>Null string</ExpectedInput>
		///		<ExpectedOutput>Generic exception error message</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Constructor with string parameter
		/// </summary>
		public BrokenRuleException(string message) : base(message)
		{
		} 

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>09/03/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3415"> 
		///		<ExpectedInput>String and Exception</ExpectedInput>
		///		<ExpectedOutput>BrokenRuleException object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3416"> 
		///		<ExpectedInput>Null message and null exception</ExpectedInput>
		///		<ExpectedOutput>Generic exception error message and null value for inner exception</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Constructor with string and exception parameters
		/// </summary>
		public BrokenRuleException(string message, Exception inner) : base(message, inner)
		{
		}

		/// <summary>
		/// BrokenRuleException
		/// </summary>
		/// <param name="info">info</param>
		/// <param name="context">context</param>
		protected BrokenRuleException(SerializationInfo info, StreamingContext context) : base (info, context)
		{  
			_OSVersion = info.GetString("_OSVersion");
			_stackTrace = info.GetString("_stackTrace");
			_machineName = info.GetString("_machineName");
			_userName = info.GetString("_userName");
		}
	

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>09/03/2003</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="3414"> 
		///		<ExpectedInput>Valid info and context objects</ExpectedInput>
		///		<ExpectedOutput>Valid object data in OS, user name</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2996"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// override GetObjectData to serialize state data
		/// </summary>
		[SecurityPermission(SecurityAction.Demand, SerializationFormatter = true)]
		public override void GetObjectData(SerializationInfo info, StreamingContext context)
		{
			info.AddValue("_OSVersion", _OSVersion, typeof(string));
			info.AddValue("_stackTrace", _stackTrace, typeof(string));
			info.AddValue("_machineName", _machineName, typeof(string));
			info.AddValue("_userName", _userName, typeof(string));
			base.GetObjectData(info, context);
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>09/03/2003</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="3413"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Valid string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3014"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Operating system version
		/// </summary>
		public string OSVersion
		{
			get
			{
				return _OSVersion;
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>09/03/2003</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="3412"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Valid string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3015"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// User name
		/// </summary>
		public string UserName
		{
			get 
			{
				return _userName;
			}
		}
	}
}
